<?php
require '../config/db.php';

// Get the owing_id from the URL and validate it
$owing_id = isset($_GET['owing_id']) ? (int) $_GET['owing_id'] : 0;

if ($owing_id === 0) {
    die("Invalid Owing ID.");
}

try {
    // Fetch the person's name and total amount owed from the owings table
    $sql = "SELECT person_name, amount AS total_amount_owed FROM owings WHERE id = :owing_id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['owing_id' => $owing_id]);
    $owing_record = $stmt->fetch();

    if ($owing_record) {
        $person_name = $owing_record['person_name'];
        $total_amount_owed = $owing_record['total_amount_owed'];
    } else {
        $person_name = "Unknown Person";
        $total_amount_owed = 0;
    }

    // Fetch all payment records and calculate the total amount paid
    $sql = "SELECT id, amount_paid, payment_date FROM payments WHERE owing_id = :owing_id ORDER BY payment_date DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['owing_id' => $owing_id]);
    $payments = $stmt->fetchAll();

    // Calculate total amount paid
    $total_amount_paid = array_sum(array_column($payments, 'amount_paid'));
    $balance_due = $total_amount_owed ;

} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payment History</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <script src="..\libs\popper\popper.min.js"></script>
    <script src="..\libs\jquery\jquery-3.7.1.min.js"></script>
    <script src="..\libs\jquery\jquery-3.3.1.slim.min.js"></script>

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <!-- Back to Owing Button -->
        <a href="owing_management.php" class="btn btn-primary mb-4">Back to Owing</a>

        <!-- Receipt Style Summary -->
        <div class="card mb-4">
            <div class="card-header bg-info text-white">
                <h4 class="mb-0">Payment Receipt for <?= htmlspecialchars($person_name) ?></h4>
            </div>
            <div class="card-body">
                <p><strong>Total Amount Owed:</strong> &#8358;<?= number_format($total_amount_owed +$total_amount_paid , 2) ?></p>
                <p><strong>Total Amount Paid:</strong> &#8358;<?= number_format($total_amount_paid, 2) ?></p>
                <p><strong>Balance Due:</strong> &#8358;<?= number_format($balance_due, 2) ?></p>
            </div>
        </div>

        <!-- Payment History Table -->
        <h2 class="mb-4">Payment History</h2>
        <?php if ($payments) { ?>
            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead class="thead-dark">
                        <tr>
                            <th>Payment ID</th>
                            <th>Amount Paid (&#8358;)</th>
                            <th>Payment Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($payments as $payment) { ?>
                            <tr>
                                <td><?= htmlspecialchars($payment['id']); ?></td>
                                <td>&#8358;<?= number_format($payment['amount_paid'], 2); ?></td>
                                <td><?= htmlspecialchars($payment['payment_date']); ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        <?php } else { ?>
            <p>No payment history available for this record.</p>
        <?php } ?>
    </div>
</body>
</html>
