<?php
session_start();
include '../config/db.php';

// Check if user is logged in
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Get the user's role
$user_role = $_SESSION['role']; // Assuming role is stored in the session when user logs in

// Handle search functionality
$search = '';
if (isset($_GET['search'])) {
    $search = trim($_GET['search']);
    $stmt = $pdo->prepare("SELECT * FROM patients WHERE patient_name LIKE ? OR contact LIKE ? ORDER BY added_date DESC");
    $stmt->execute(['%' . $search . '%', '%' . $search . '%']);
} else {
    // Fetch all patients if no search term
    $stmt = $pdo->query("SELECT * FROM patients ORDER BY added_date DESC");
}
$patients = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Patients</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <script src="..\libs\popper\popper.min.js"></script>
    <script src="..\libs\jquery\jquery-3.7.1.min.js"></script>
    <script src="..\libs\jquery\jquery-3.3.1.slim.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="content">
        <div class="container mt-5">
            <h2 class="mb-4">Patients List</h2>

            <!-- Button section -->
            <div class="d-flex justify-content-between mb-3">
                <a href="admin_dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
                <?php if ($user_role !== 'staff'): ?>
                    <a href="patient.php" class="btn btn-success">Add New Patient</a>
                <?php endif; ?>
            </div>

            <!-- Search Form -->
            <form method="get" class="mb-4">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="Search by name or contact" value="<?= htmlspecialchars($search) ?>">
                    <button type="submit" class="btn btn-primary">Search</button>
                </div>
            </form>

            <!-- Table of All Patients -->
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Age</th>
                        <th>Gender</th>
                        <th>Diagnosis</th>
                        <th>Temperature</th>
                        <th>Contact</th>
                        <th>Added By</th>
                        <th>Date Added</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($patients) > 0): ?>
                        <?php foreach ($patients as $index => $patient): ?>
                        <tr>
                            <td><?= $index + 1 ?></td>
                            <td><?= htmlspecialchars($patient['patient_name']) ?></td>
                            <td><?= htmlspecialchars($patient['patient_age']) ?></td>
                            <td><?= htmlspecialchars($patient['patient_gender']) ?></td>
                            <td><?= htmlspecialchars($patient['diagnosis']) ?></td>
                            <td><?= htmlspecialchars($patient['temperature']) ?></td>
                            <td><?= htmlspecialchars($patient['contact']) ?></td>
                            <td><?= htmlspecialchars($patient['added_by']) ?></td>
                            <td><?= htmlspecialchars($patient['added_date']) ?></td>
                            <td>
                                <a href="view_prescriptions.php?patient_id=<?= $patient['id'] ?>" class="btn btn-primary btn-sm">View Prescriptions</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="9" class="text-center">No patients found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
