<?php
include '../config/db.php';

// Get the product ID from the URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "Invalid product ID.";
    exit;
}

$product_id = $_GET['id'];

// Fetch product details and history
try {
    // Fetch product details
    $stmt = $pdo->prepare("SELECT drug_name as product_name FROM drugs WHERE id = ?");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$product) {
        echo "Product not found.";
        exit;
    }

    // Fetch product history
    $historyStmt = $pdo->prepare("
        SELECT 
            action, quantity, details, user, action_date 
        FROM drug_history 
        WHERE drug_id = ? 
        ORDER BY id DESC
    ");
    $historyStmt->execute([$product_id]);
    $history = $historyStmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product History</title>
    <link rel="stylesheet" href="..\libs\bootsrtap2\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <style>
        body {
            background-color: #f5f6fa;
            font-family: Arial, sans-serif;
            font-size: 14px;
        }

        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 20px;
        }

        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .table-container {
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .table thead th {
            background-color: #2c3e50;
            color: #fff;
            padding: 12px;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
        }

        .search-box {
            background: #fff;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #2c3e50, #3498db);
            border: none;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: #2980b9;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="top-bar">
            <h2 class="mb-0">
                <i class="fas fa-history"></i> 
                Product History: <?= htmlspecialchars($product['product_name']); ?>
            </h2>
            <a href="manage_drugs.php" class="btn btn-primary">
                <i class="fas fa-arrow-left"></i> Back to Products
            </a>
        </div>

        <div class="search-box">
            <div class="input-group">
                <span class="input-group-text">
                    <i class="fas fa-search"></i>
                </span>
                <input type="text" id="searchInput" class="form-control" 
                       placeholder="Search history...">
            </div>
        </div>

        <div class="table-container">
            <table id="historyTable" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th><i class="fas fa-calendar"></i> Date</th>
                        <th><i class="fas fa-tasks"></i> Action</th>
                        <th><i class="fas fa-boxes"></i> Quantity</th>
                        <th><i class="fas fa-info-circle"></i> Details</th>
                        <th><i class="fas fa-user"></i> User</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($history)): ?>
                        <?php foreach ($history as $record): ?>
                            <tr>
                                <td><?= htmlspecialchars(date("d M Y, h:i A", strtotime($record['action_date']))); ?></td>
                                <td><?= htmlspecialchars($record['action']); ?></td>
                                <td><?= htmlspecialchars($record['quantity']); ?></td>
                                <td><?= htmlspecialchars($record['details']); ?></td>
                                <td><?= htmlspecialchars($record['user']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted">
                                <i class="fas fa-info-circle"></i> No history found for this product.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script src="..\libs\bootsrtap2\js\bootstrap.bundle.min.js"></script>
    <script>
        // JavaScript to filter table based on search input
        document.getElementById('searchInput').addEventListener('input', function () {
            let filter = this.value.toLowerCase();
            let rows = document.querySelectorAll('#historyTable tbody tr');
            
            rows.forEach(function (row) {
                let cells = row.getElementsByTagName('td');
                let match = false;
                
                // Loop through the cells to check if any cell contains the search term
                for (let i = 0; i < cells.length; i++) {
                    if (cells[i].textContent.toLowerCase().includes(filter)) {
                        match = true;
                        break;
                    }
                }
                
                // Show or hide row based on whether a match is found
                if (match) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    </script>
</body>
</html>
