<?php
session_start();
require_once('../config/db.php');

try {
    // Get notification setting from POST
    $notifications_enabled = isset($_POST['notifications_enabled']) ? 1 : 0;

    // Update settings with ID 1 (main settings record)
    $sql = "UPDATE settings SET notifications_enabled = :notifications_enabled WHERE id = 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'notifications_enabled' => $notifications_enabled
    ]);

    // Set success message
    $_SESSION['success'] = "Notification settings updated successfully!";
} catch (PDOException $e) {
    // Set error message
    $_SESSION['error'] = "Failed to update notification settings: " . $e->getMessage();
}

// Redirect back to settings page
header('Location: settings.php');
exit;
?>
