<?php
session_start();
include '../config/db.php';

// Initialize variables for highest sales and spending
$staffs = [];
$customers = [];
$date_filter_query = '';

// Check if date range filter is provided
if (isset($_POST['start_date']) && isset($_POST['end_date']) && !empty($_POST['start_date']) && !empty($_POST['end_date'])) {
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $date_filter_query = " AND sale_date BETWEEN '$start_date' AND '$end_date'";
} else {
    $start_date = '';
    $end_date = '';
}

try {
    // Query to get top 5 staff with highest sales
    $stmt_staff = $pdo->prepare("
        SELECT username, SUM(total) as total_sales 
        FROM sales 
        WHERE refunded = 0
        $date_filter_query
        GROUP BY username 
        ORDER BY total_sales DESC 
        LIMIT 5
    ");
    $stmt_staff->execute();
    $staffs = $stmt_staff->fetchAll(PDO::FETCH_ASSOC);

    // Query to get top 5 customers with highest spending and their full details
    $stmt_customer = $pdo->prepare("
        SELECT customer_id, full_name, SUM(total) as total_spent 
        FROM sales
        JOIN customers ON sales.customer_id = customers.id
        WHERE refunded = 0
        $date_filter_query
        GROUP BY customer_id 
        ORDER BY total_spent DESC 
        LIMIT 5
    ");
    $stmt_customer->execute();
    $customers = $stmt_customer->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Staff Report - Store Management</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    
    <style>
        body {
            background-color: #f5f6fa;
            font-family: 'Mulish', sans-serif;
            overflow-x: hidden;
        }

        .content {
            margin-left: 240px;
            padding: 20px;
            transition: margin-left 0.3s ease;
        }

        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .report-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }

        .card-header {
            background: #2c3e50;
            color: white;
            padding: 15px;
            border-radius: 10px 10px 0 0;
        }

        .card-body {
            padding: 20px;
        }

        .table thead th {
            background-color: #2c3e50;
            color: white;
            font-weight: 500;
            border: none;
        }

        .table td {
            vertical-align: middle;
        }

        .filter-section {
            background: white;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        @media (max-width: 768px) {
            .content {
                margin-left: 0;
                padding: 10px;
            }
            
            .mobile-toggle {
                display: block;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/side_bar.php'; ?>

    <!-- Mobile Toggle Button -->
    <button class="mobile-toggle d-md-none" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </button>

    <div class="content">
        <!-- Top Bar -->
        <div class="top-bar">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Staff Performance Report</h4>
                <a href="admin_dashboard.php" class="btn btn-outline-primary">
                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                </a>
            </div>
        </div>

        <!-- Filter Section -->
        <div class="filter-section">
            <form class="row g-3" method="POST">
                <div class="col-md-4">
                    <label class="form-label">Start Date</label>
                    <input type="date" class="form-control" name="start_date" 
                           value="<?= htmlspecialchars($start_date) ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">End Date</label>
                    <input type="date" class="form-control" name="end_date" 
                           value="<?= htmlspecialchars($end_date) ?>">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-filter"></i> Apply Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Staff Report -->
        <div class="report-card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-user-tie"></i> Top 5 Staff Performance</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Staff Name</th>
                                <th class="text-end">Total Sales (₦)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($staffs)): ?>
                                <?php foreach ($staffs as $index => $staff): ?>
                                    <tr>
                                        <td><span class="badge bg-primary">#<?= ($index + 1) ?></span></td>
                                        <td><?= htmlspecialchars($staff['username']) ?></td>
                                        <td class="text-end">₦<?= number_format($staff['total_sales'], 2) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="3" class="text-center">No data available</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Customer Report -->
        <div class="report-card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-users"></i> Top 5 Customer Spending</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Customer Name</th>
                                <th class="text-end">Total Spent (₦)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($customers)): ?>
                                <?php foreach ($customers as $index => $customer): ?>
                                    <tr>
                                        <td><span class="badge bg-success">#<?= ($index + 1) ?></span></td>
                                        <td><?= htmlspecialchars($customer['full_name']) ?></td>
                                        <td class="text-end">₦<?= number_format($customer['total_spent'], 2) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="3" class="text-center">No data available</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="..\libs\jquery\jquery-3.7.1.min.js"></script>
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <script>
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
            document.querySelector('.content').classList.toggle('sidebar-active');
        }
    </script>
</body>
</html>
