<?php
// Include the database connection
include '../config/db.php';

// Check if a search query is provided
if (isset($_GET['query'])) {
    $query = htmlspecialchars($_GET['query']);
    // Query to search for drugs by name
    $stmt = $pdo->prepare("SELECT drug_name FROM drugs WHERE drug_name LIKE ? LIMIT 5");
    $stmt->execute(['%' . $query . '%']);
    $drugs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($drugs) {
        foreach ($drugs as $drug) {
            echo '<a href="javascript:void(0);" class="list-group-item suggestion-item">' . htmlspecialchars($drug['drug_name']) . '</a>';
        }
    } else {
        echo '<p class="list-group-item">No drugs found</p>';
    }
}
?>
