<?php
session_start();

try {
    // Get JSON data from request
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        throw new Exception('Invalid data received');
    }

    // Save to session
    $_SESSION['accounting_data'] = $data;
    
    // Return success response
    echo json_encode([
        'success' => true,
        'message' => 'Data saved to session successfully'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}