<?php
session_start();
include '../config/db.php';

// Initialize filter variables
$searchTerm = $_POST['search'] ?? '';
$startDate = $_POST['start_date'] ?? '';
$endDate = $_POST['end_date'] ?? '';

// Build the query with filters
$refundQuery = "SELECT r.id, s.receipt, r.drug_name as product_name, r.quantity, r.refunded_by, r.refund_date 
                FROM refund r 
                JOIN sales s ON r.sale_id = s.id 
                WHERE 1=1";
$params = [];

if (!empty($searchTerm)) {
    $refundQuery .= " AND (r.drug_name LIKE ? OR s.receipt LIKE ? OR r.refunded_by LIKE ?)";
    $params[] = "%$searchTerm%";
    $params[] = "%$searchTerm%";
    $params[] = "%$searchTerm%";
}

if (!empty($startDate) && !empty($endDate)) {
    $refundQuery .= " AND DATE(r.refund_date) BETWEEN ? AND ?";
    $params[] = $startDate;
    $params[] = $endDate;
}

$refundQuery .= " ORDER BY r.refund_date DESC";

$refundStmt = $pdo->prepare($refundQuery);
$refundStmt->execute($params);
$refundRecords = $refundStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Refund Records | Store Management</title>
    <link rel="stylesheet" href="..\libs\bootsrtap2\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <style>
        body {
            background-color: #f5f6fa;
            font-family: Arial, sans-serif;
            font-size: 14px;
        }

        .container {
            padding: 20px;
            scroll-padding-top: 70px; /* Height of your sticky header */
        }

        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .table-container {
            margin-top: 20px;  /* Adjust spacing since summary card is removed */
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 1;
        }

        .table thead th {
            background-color: #2c3e50;
            color: #fff;
            padding: 12px;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
        }

        .btn-primary {
            background: linear-gradient(135deg, #2c3e50, #3498db);
            border: none;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: #2980b9;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="top-bar">
            <div class="d-flex justify-content-between align-items-center">
                <h2><i class="fas fa-undo"></i> Refund Records</h2>
                <a href="sales.php" class="btn btn-primary">
                    <i class="fas fa-arrow-left"></i> Back to Sales
                </a>
            </div>
        </div>

        <div class="filter-container bg-white p-3 mb-4 rounded shadow-sm">
            <form method="POST" class="row g-3">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-search"></i>
                        </span>
                        <input type="text" name="search" class="form-control" 
                               placeholder="Search by product, receipt or staff..."
                               value="<?= htmlspecialchars($searchTerm) ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-calendar"></i>
                        </span>
                        <input type="date" name="start_date" class="form-control" 
                               value="<?= htmlspecialchars($startDate) ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-calendar"></i>
                        </span>
                        <input type="date" name="end_date" class="form-control" 
                               value="<?= htmlspecialchars($endDate) ?>">
                    </div>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>

        <?php if (isset($_SESSION['success']) || isset($_SESSION['error'])): ?>
            <div class="alert alert-<?= isset($_SESSION['success']) ? 'success' : 'danger' ?>">
                <i class="fas fa-<?= isset($_SESSION['success']) ? 'check-circle' : 'exclamation-circle' ?>"></i>
                <?= $_SESSION['success'] ?? $_SESSION['error'] ?>
            </div>
            <?php unset($_SESSION['success'], $_SESSION['error']); ?>
        <?php endif; ?>

        <div class="table-container">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><i class="fas fa-hashtag"></i> ID</th>
                        <th><i class="fas fa-receipt"></i> Receipt</th>
                        <th><i class="fas fa-box"></i> Product Name</th>
                        <th><i class="fas fa-sort-numeric-down"></i> Quantity</th>
                        <th><i class="fas fa-user"></i> Refunded By</th>
                        <th><i class="fas fa-calendar"></i> Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($refundRecords)): ?>
                        <?php foreach ($refundRecords as $record): ?>
                            <tr>
                                <td><?= htmlspecialchars($record['id']) ?></td>
                                <td><?= htmlspecialchars($record['receipt']) ?></td>
                                <td><?= htmlspecialchars($record['product_name']) ?></td>
                                <td><?= htmlspecialchars($record['quantity']) ?></td>
                                <td><?= htmlspecialchars($record['refunded_by']) ?></td>
                                <td><?= date('d M Y, h:i A', strtotime($record['refund_date'])) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted">
                                <i class="fas fa-info-circle"></i> No refund records found
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
