<?php
session_start();
include '../config/db.php';

// Check if the user is logged in
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Fetch all patients for dropdown
$stmt = $pdo->query("SELECT id, patient_name FROM patients");
$patients = $stmt->fetchAll();

// Handle form submission for adding prescriptions
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_prescription'])) {
    $patient_id = $_POST['patient_id'];
    $drug_name = $_POST['drug_name'];
    $dosage = $_POST['dosage'];
    $frequency = $_POST['frequency'];
    $duration = $_POST['duration'];
    $prescribed_by = $_SESSION['username'];

    // Insert the prescription into the database
    $stmt = $pdo->prepare("INSERT INTO prescriptions (patient_id, drug_name, dosage, frequency, duration, prescribed_by) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$patient_id, $drug_name, $dosage, $frequency, $duration, $prescribed_by]);

    echo "<div class='alert alert-success'>Prescription added successfully!</div>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Prescription</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2 class="mb-4">Add Prescription</h2>

    <form method="post">
        <div class="mb-3">
            <label for="patient_id" class="form-label">Select Patient</label>
            <select class="form-control" id="patient_id" name="patient_id" required>
                <?php foreach ($patients as $patient): ?>
                    <option value="<?= $patient['id'] ?>"><?= htmlspecialchars($patient['patient_name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="mb-3">
            <label for="drug_name" class="form-label">Drug Name</label>
            <input type="text" class="form-control" id="drug_name" name="drug_name" required>
        </div>
        <div class="mb-3">
            <label for="dosage" class="form-label">Dosage</label>
            <input type="text" class="form-control" id="dosage" name="dosage" required>
        </div>
        <div class="mb-3">
            <label for="frequency" class="form-label">Frequency</label>
            <input type="text" class="form-control" id="frequency" name="frequency" required>
        </div>
        <div class="mb-3">
            <label for="duration" class="form-label">Duration</label>
            <input type="text" class="form-control" id="duration" name="duration" required>
        </div>
        <button type="submit" name="add_prescription" class="btn btn-primary">Add Prescription</button>
    </form>
</div>

</body>
</html>
