<?php
session_start();
include '../config/db.php';

// Check if the user is logged in
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Handle form submission for adding patients
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_patient'])) {
    $name = $_POST['name'];
    $age = $_POST['age'];
    $gender = $_POST['gender'];
    $temperature = $_POST['temperature'];
    $contact = $_POST['contact'];
    $diagnosis = $_POST['diagnosis'];
    $added_by = $_SESSION['username'];

    // Insert the patient into the database
    $stmt = $pdo->prepare("INSERT INTO patients (patient_name, patient_age, patient_gender, temperature, contact, diagnosis, added_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$name, $age, $gender, $temperature, $contact, $diagnosis, $added_by]);

    echo "<div class='alert alert-success text-center'>Patient added successfully!</div>";
}
include('../includes/side_bar.php')
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Patient</title>

    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom styles for enhanced layout -->
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Arial', sans-serif;
        }
        .sidebar {
            width: 220px;
            position: fixed;
            height: 100vh;
            font-size: 14px;
            max-height: 100vh; /* Ensure it doesn't exceed viewport height */
            background-color: #2c3e50;
            color: #fff;
            padding-top: 30px;
            padding-left: 15px ; 
            transition: transform 0.3s ease;
            z-index: 1000;
            overflow-y: auto; /* Enables vertical scrolling */
        }
        .sidebar h2 {
            padding: 10px;
        
            text-align: center;
            font-size: 1.6em;
            margin-bottom: 10px;
            font-weight: bold;
        }
        .sidebar a {
            display: block;
            padding: 15px;
            color: #fff;
            text-decoration: none;
            font-size: 14px;
            margin-bottom: 10px;
            border-left: 4px solid transparent;
            transition: all 0.3s ease;
        }
        .sidebar a:hover {
            background-color: rgba(255, 255, 255, 0.2); /* White with 50% transparency */
            color: red;
            border-left: 6px solid #3498db;
        }
        .content {
            margin-left: 230px;
            padding: 20px;
            transition: margin-left 0.3s ease;
        }
        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .top-bar h4 {
            margin: 0;
            font-weight: bold;
            color: #343a40;
        }
        .ftop-bar {
    background-color: #ffffff;
    padding: 15px;
    
    display: flex;
    justify-content: space-between;
    align-items: center;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    border-radius: 5px;
    margin-bottom: 1px;

    position: sticky; /* Makes the element sticky */
    top: 0; /* Sticks at the top when scrolling */
    z-index: 1000; /* Ensures it stays above other elements */
}

        .report-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .report-card {
            padding: 20px;
            border-radius: 10px;
            color: #fff;
            text-align: center;
            margin-bottom: 20px;
            transition: transform 0.3s;
        }
        .report-card:hover {
            transform: translateY(-5px);
        }
        .report-card h4 {
    font-size: 1.5em; /* Increase heading size */
}

.report-card p {
    font-size: 1.8em; /* Increase text size */
}
.close_nav{
            display:none;
        }
        .show_nav{
            display:none;
        }
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .content {
                margin-left: 0;
            }
            .close_nav{
                display:inline-block;
            }
            .show_nav{
            display:inline-block;
        }
    }

        .total-sales-card { background-color: #007bff; }
        .total-profit-card { background-color: #28a745; }
        .total-discount-card { background-color: #ffc107; }
        .total-expenses-card { background-color: #dc3545; }
        .total-owings-card { background-color: #17a2b8; }
        .most-sold-drug-card { background-color: #6f42c1; }

@media screen and (max-width:768px) {
    .content {
            margin:30px auto;
            padding: 20px;
            overflow-x: auto;
        }
}
    </style>
</head>
<body>

<div class="container">
    <h2 class="mb-4 text-center">Add New Patient</h2>

    <!-- Back to Patient List Button -->
    <div class="d-flex justify-content-between mb-4">
        <a href="view_patients.php" class="btn btn-secondary btn-back">Back to Patient List</a>
    </div>

    <!-- Add Patient Form -->
    <form method="post" class="needs-validation" novalidate>
        <div class="mb-3">
            <label for="name" class="form-label">Patient Name</label>
            <input type="text" class="form-control" id="name" name="name" required>
            <div class="invalid-feedback">Please enter the patient's name.</div>
        </div>
        <div class="mb-3">
            <label for="age" class="form-label">Age</label>
            <select class="form-control" id="age" name="age" required>
                <option value="" disabled selected>Select Age</option>
                <option value="Child">Child</option>
                <option value="Adult">Adult</option>
            </select>
            <div class="invalid-feedback">Please enter the patient's age.</div>
        </div>
        <div class="mb-3">
            <label for="gender" class="form-label">Gender</label>
            <select class="form-control" id="gender" name="gender" required>
                <option value="" disabled selected>Select Gender</option>
                <option value="Male">Male</option>
                <option value="Female">Female</option>
            </select>
            <div class="invalid-feedback">Please select the patient's gender.</div>
        </div>
        <div class="mb-3">
            <label for="temperature" class="form-label">Temperature</label>
            <input type="text" class="form-control" id="temperature" name="temperature" required>
            <div class="invalid-feedback">Please provide the temperature.</div>
        </div>
        <div class="mb-3">
            <label for="contact" class="form-label">Contact</label>
            <input type="text" class="form-control" id="contact" name="contact" required>
            <div class="invalid-feedback">Please provide a contact.</div>
        </div>
        <div class="mb-3">
            <label for="diagnosis" class="form-label">Diagnosis</label>
            <textarea class="form-control" id="diagnosis" name="diagnosis" rows="3" required></textarea>
            <div class="invalid-feedback">Please provide a diagnosis.</div>
        </div>
        <button type="submit" name="add_patient" class="btn btn-primary w-100">Add Patient</button>
    </form>
</div>

<script>
// Bootstrap form validation
(function() {
    'use strict';
    window.addEventListener('load', function() {
        var forms = document.getElementsByClassName('needs-validation');
        Array.prototype.filter.call(forms, function(form) {
            form.addEventListener('submit', function(event) {
                if (form.checkValidity() === false) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });
    }, false);
})();
</script>

</body>
</html>
