<?php
// public/manager_dashboard.php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'manager') {
    header("Location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manager Dashboard</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            color: #343a40;
            overflow-x: hidden;
        }
        .sidebar {
            min-height: 100vh;
            background-color: #004d40; /* Dark teal */
            padding: 20px;
            transition: all 0.3s ease;
        }
        .sidebar a {
            color: #ffffff;
            transition: all 0.3s ease;
        }
        .sidebar a:hover {
            background-color: #00695c; /* Lighter teal on hover */
            border-radius: 5px;
        }
        .content {
            padding: 20px;
            flex-grow: 1;
        }
        .card {
            background-color: #ffffff;
            border: none;
            transition: transform 0.3s;
        }
        .card:hover {
            transform: scale(1.05);
        }
        .card-header {
            background-color: #004d40; /* Dark teal card headers */
            color: white;
        }
        .footer {
            background-color: #004d40; /* Dark teal footer */
            padding: 10px;
            text-align: center;
            color: white;
        }
        .btn-primary {
            background-color: #00695c;
            border-color: #00695c;
        }
        .btn-primary:hover {
            background-color: #004d40;
            border-color: #004d40;
        }
        @media (max-width: 576px) {
            .sidebar {
                display: none; /* Hide sidebar on small screens */
            }
            .content {
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar">
            <h2 class="text-center">Manager Panel</h2>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link" href="manage_drugs.php"><i class="fas fa-pills"></i> Manage Drugs</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="manager_dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="view_reports.php"><i class="fas fa-file-alt"></i> View Reports</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="add_drug.php"><i class="fas fa-plus"></i> Add Drug</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="settings.php"><i class="fas fa-cogs"></i> Settings</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </li>
            </ul>
        </div>

        <!-- Main Content -->
        <div class="content">
            <div class="container-fluid">
                <h2 class="my-4">Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>!</h2>

                <!-- Section for Drug Management -->
                <div class="row">
                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>Manage Drugs</h5>
                            </div>
                            <div class="card-body text-center">
                                <h1 class="display-4"><i class="fas fa-pills"></i></h1>
                                <p>Add or manage drugs in the system.</p>
                                <a href="add_drug.php" class="btn btn-primary">Add Drug</a>
                                <a href="manage_drugs.php" class="btn btn-secondary">View Drugs</a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>Total Reports</h5>
                            </div>
                            <div class="card-body text-center">
                                <h1 class="display-4">45</h1>
                                <p>View and analyze reports.</p>
                                <a href="view_reports.php" class="btn btn-primary">View Reports</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>Settings</h5>
                            </div>
                            <div class="card-body text-center">
                                <h1 class="display-4"><i class="fas fa-cogs"></i></h1>
                                <p>Configure application settings.</p>
                                <a href="settings.php" class="btn btn-primary">Go to Settings</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>System Status</h5>
                            </div>
                            <div class="card-body text-center">
                                <h1 class="display-4"><i class="fas fa-check-circle text-success"></i></h1>
                                <p>System is running smoothly.</p>
                                <a href="#" class="btn btn-primary">Check Status</a>
                            </div>
                        </div>
                    </div>
                </div>

                <footer class="footer mt-5">
                    <p>&copy; <?php echo date("Y"); ?> Your Company Name. All rights reserved.</p>
                </footer>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>
