<?php
session_start(); // Start the session at the top

// Check if the user is already logged in
if (isset($_SESSION['username'])) {
    // Redirect based on role if already logged in
    switch ($_SESSION['role']) {
        case 'admin':
            header("Location: admin_dashboard.php");
            exit();
        case 'manager':
            header("Location: manager_dashboard.php");
            exit();
        case 'staff':
            header("Location: staff_dashboard.php");
            exit();
        default:
            // Handle unexpected role if necessary
            break;
    }
}

include '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Fetch user data from the database
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    // Check if user exists and verify the password
    if ($user && password_verify($password, $user['password'])) {
        // Set session variables
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'];

        // Log the login action
$stmt = $pdo->prepare("INSERT INTO log_history (user_id, action) VALUES (?, 'login')");
$stmt->execute([$user['id']]);

        // Redirect based on role
        switch ($user['role']) {
            case 'admin':
                header("Location: admin_dashboard.php");
                exit(); // Important to stop script execution after redirect
            case 'manager':
                header("Location: manager_dashboard.php");
                exit();
            case 'staff':
                header("Location: staff_dashboard.php");
                exit();
            default:
                // Handle unexpected role
                $message = "<div class='alert alert-danger text-center'>Unexpected user role. Please contact support.</div>";
                break;
        }
    } else {
        $message = "<div class='alert alert-danger text-center'>Invalid username or password</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>InkeepX - POS Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
    :root {
        --primary: #dc2626;
        --secondary: #b91c1c;
        --accent: #ef4444;
        --white: #ffffff;
        --dark: #111827;
        --gray: #6b7280;
        --light: #f3f4f6;
        --error: #dc2626;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: 'Poppins', sans-serif;
    }

    body {
        background-image: url('assets/images/supermarket.jpg');
        background-size: cover;
        background-position: center;
        background-attachment: fixed;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }

    body::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(45deg, rgba(15, 23, 42, 0.9), rgba(15, 23, 42, 0.7));
        backdrop-filter: blur(10px);
        z-index: 1;
    }

    .login-container {
        position: relative;
        z-index: 2;
        width: 100%;
        max-width: 360px; /* Reduced from 420px */
        background: var(--white);
        border-radius: 16px;
        padding: 2rem; /* Reduced from 2.5rem */
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        border-top: 4px solid var(--primary);
    }

    .login-header {
        text-align: center;
        margin-bottom: 2rem; /* Reduced from 2.5rem */
    }

    .login-logo {
        font-size: 1.8rem;
        color: var(--primary);
        margin-bottom: 0.75rem;
    }

    .login-title {
        font-size: 1.25rem;
        color: var(--dark);
        font-weight: 600;
        margin-bottom: 0.25rem;
    }

    .login-subtitle {
        color: var(--gray);
        font-size: 0.875rem;
    }

    .form-group {
        margin-bottom: 1.25rem;
        position: relative;
    }

    .form-control {
        width: 100%;
        height: 45px; /* Reduced from 50px */
        background: var(--light);
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 0 1rem;
        font-size: 0.9rem;
        transition: all 0.2s ease;
    }

    .form-control:focus {
        border-color: var(--primary);
        background: var(--white);
        box-shadow: 0 0 0 3px rgba(220, 38, 38, 0.1);
    }

    .btn-login {
        width: 100%;
        height: 45px; /* Reduced from 50px */
        background: var(--primary);
        color: var(--white);
        border: none;
        border-radius: 8px;
        font-size: 0.95rem;
        font-weight: 500;
        transition: all 0.2s ease;
    }

    .btn-login:hover {
        background: var(--secondary);
        transform: translateY(-1px);
        box-shadow: 0 8px 15px rgba(220, 38, 38, 0.2);
    }

    .form-check-input:checked {
        background-color: var(--primary);
        border-color: var(--primary);
    }

    .alert {
        background: #fef2f2;
        border-left: 4px solid var(--primary);
        padding: 0.75rem 1rem;
        border-radius: 6px;
        margin-bottom: 1rem;
        font-size: 0.875rem;
        color: var(--primary);
    }

    @media (max-width: 480px) {
        .login-container {
            margin: 1rem;
            padding: 1.5rem;
        }
    }
</style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <div class="login-logo">
                <i class="fas fa-shield-alt"></i> InkeepX
            </div>
            <h2 class="login-title">Welcome to InkeepX</h2>
            <p class="login-subtitle">Sign in to access your dashboard</p>
        </div>

        <?php if (isset($message)) echo $message; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label class="form-label">Username</label>
                <input type="text" 
                       class="form-control" 
                       name="username" 
                       required>
            </div>

            <div class="form-group">
                <label class="form-label">Password</label>
                <input type="password" 
                       class="form-control" 
                       name="password" 
                       id="password" 
                       required>
            </div>

            <div class="d-flex justify-content-between align-items-center mb-4">
                <div class="form-check">
                    <input type="checkbox" 
                           class="form-check-input" 
                           id="remember" 
                           name="remember">
                    <label class="form-check-label" for="remember">
                        Remember me
                    </label>
                </div>
            </div>

            <button type="submit" class="btn-login">
                Access POS System
            </button>
        </form>
    </div>
</body>
</html>
