<?php
session_start();
require_once '../config/db.php';

try {
    $date = $_GET['date'] ?? date('Y-m-d');
    
    $stmt = $pdo->prepare("
        SELECT * FROM accounting_entries 
        WHERE entry_date = ?
        ORDER BY section, id
    ");
    $stmt->execute([$date]);
    $entries = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'data' => $entries]);
    
} catch (Exception $e) {
    error_log("Error loading entries: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Error loading entries']);
}