<?php
require_once '../config/db.php'; // Database connection

if (isset($_GET['drug_id'])) {
    $drug_id = $_GET['drug_id'];

    // Fetch the drug details
    $sql = "SELECT cost_price, selling_price, quantity, volume_size, volume_price FROM drugs WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$drug_id]);
    $drug = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($drug) {
        // Return the drug details in JSON format
        echo json_encode([
            'cost_price' => $drug['cost_price'],
            'selling_price' => $drug['selling_price'],
            'available_quantity' => $drug['quantity'],
            'volume_size' => $drug['volume_size'],
            'volume_price' => $drug['volume_price']
        ]);
    } else {
        echo json_encode([]);
    }
}
?>
