<?php
// Include necessary PhpSpreadsheet files
require_once '../libs/PhpSpreadsheet/src/PhpSpreadsheet/IOFactory.php';  // Handles various readers and writers
require_once '../libs/PhpSpreadsheet/src/PhpSpreadsheet/Writer/Xlsx.php';  // Handles Xlsx writing

session_start();
include('../config/db.php');  // Include your database connection

// Fetch report data
$report_type = isset($_POST['report_type']) ? $_POST['report_type'] : 'daily';

// Define the query
switch ($report_type) {
    case 'daily':
        $sales_query = "SELECT DATE(sale_date) AS sale_date, SUM(total) AS total_sales, SUM(profit) AS total_profit FROM sales GROUP BY DATE(sale_date)";
        break;
    case 'weekly':
        $sales_query = "SELECT YEARWEEK(sale_date) AS sale_date, SUM(total) AS total_sales, SUM(profit) AS total_profit FROM sales GROUP BY YEARWEEK(sale_date)";
        break;
    case 'monthly':
        $sales_query = "SELECT DATE_FORMAT(sale_date, '%Y-%m') AS sale_date, SUM(total) AS total_sales, SUM(profit) AS total_profit FROM sales GROUP BY DATE_FORMAT(sale_date, '%Y-%m')";
        break;
    case 'yearly':
        $sales_query = "SELECT YEAR(sale_date) AS sale_date, SUM(total) AS total_sales, SUM(profit) AS total_profit FROM sales GROUP BY YEAR(sale_date)";
        break;
}

// Fetch sales data
$sales_stmt = $pdo->query($sales_query);
$sales_data = $sales_stmt->fetchAll(PDO::FETCH_ASSOC)
    
?>
