<?php
// Include the database connection
require_once '../config/db.php';
session_start();

// Redirect if not admin
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit();
}

// Fetch customer data for editing
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    $sql = "SELECT * FROM customers WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);
    $customer = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$customer) {
        $_SESSION['message'] = "Customer not found!";
        header("Location: manage_customers.php");
        exit();
    }
}

// Update customer data
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_customer'])) {
    $id = $_POST['id'];
    $full_name = $_POST['full_name'];
    $email = $_POST['email'];
    $phone_number = $_POST['phone_number'];
    $address = $_POST['address'];
    $gender = $_POST['gender'];

    $sql = "UPDATE customers SET full_name = ?, email = ?, phone_number = ?, address = ?, gender = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$full_name, $email, $phone_number, $address, $gender, $id]);

    $_SESSION['message'] = "Customer updated successfully!";
    header("Location: manage_customers.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Customer</title>
    <link rel="stylesheet" href="../libs/bootstrap/css/bootstrap.min.css">
    <script src="../libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background: linear-gradient(135deg,rgb(246, 246, 247),rgb(248, 248, 248));
            color: #fff;
            font-family: 'Poppins', sans-serif;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .container {
            background: #fff;
            border-radius: 16px;
            padding: 30px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.2);
        }

        h2 {
            color: #343a40;
            text-align: center;
            margin-bottom: 20px;
            font-weight: bold;
        }

        label {
            font-weight: 500;
            margin-bottom: 5px;
        }

        input, textarea, select {
            background: #f7f9fc;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 10px;
            font-size: 14px;
            width: 100%;
            transition: border-color 0.3s ease;
        }

        input:focus, textarea:focus, select:focus {
            border-color: #6a11cb;
            outline: none;
            box-shadow: 0 0 8px rgba(106, 17, 203, 0.2);
        }

        .btn {
            background: linear-gradient(135deg, #6a11cb, #2575fc);
            border: none;
            color: #fff;
            font-weight: bold;
            border-radius: 8px;
            padding: 12px;
            font-size: 16px;
            width: 100%;
            margin-top: 20px;
            transition: transform 0.2s, box-shadow 0.3s;
        }

        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
        }

        .btn:active {
            transform: translateY(1px);
            box-shadow: none;
        }

        .alert {
            margin-top: 20px;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Edit Customer</h2>

        <!-- Success or Error Message -->
        <?php if (isset($_SESSION['message'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= $_SESSION['message']; unset($_SESSION['message']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Edit Customer Form -->
        <form method="POST" action="edit_customer.php">
            <input type="hidden" name="id" value="<?= $customer['id'] ?? '' ?>">

            <div class="mb-4">
                <label for="full_name" class="form-label">Full Name</label>
                <input type="text" class="form-control" id="full_name" name="full_name" 
                       value="<?= $customer['full_name'] ?? '' ?>" required>
            </div>

            <div class="mb-4">
                <label for="email" class="form-label">Email</label>
                <input type="email" class="form-control" id="email" name="email" 
                       value="<?= $customer['email'] ?? '' ?>" required>
            </div>

            <div class="mb-4">
                <label for="phone_number" class="form-label">Phone Number</label>
                <input type="text" class="form-control" id="phone_number" name="phone_number" 
                       value="<?= $customer['phone_number'] ?? '' ?>" required>
            </div>

            <div class="mb-4">
                <label for="address" class="form-label">Address</label>
                <textarea class="form-control" id="address" name="address" rows="3" required><?= $customer['address'] ?? '' ?></textarea>
            </div>

            <div class="mb-4">
                <label for="gender" class="form-label">Gender</label>
                <select class="form-select" id="gender" name="gender" required>
                    <option value="" disabled>Select Gender</option>
                    <option value="Male" <?= isset($customer['gender']) && $customer['gender'] == 'Male' ? 'selected' : '' ?>>Male</option>
                    <option value="Female" <?= isset($customer['gender']) && $customer['gender'] == 'Female' ? 'selected' : '' ?>>Female</option>
                </select>
            </div>

            <button type="submit" name="edit_customer" class="btn">Update Customer</button>
        </form>
    </div>
</body>
</html>
