<?php
session_start();

// Check if the user is logged in and has the correct role
if (!isset($_SESSION['username']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'manager')) {
    header("Location: login.php");
    exit();
}

// Include database configuration file
include '../config/db.php';

// Check if the ID is set and is a valid integer
if (isset($_GET['id']) && filter_var($_GET['id'], FILTER_VALIDATE_INT)) {
    $drugId = $_GET['id'];

    // Prepare the SQL statement to delete the drug
    $query = "DELETE FROM drugs WHERE id = :id";
    $stmt = $pdo->prepare($query);
    
    // Execute the statement with the drug ID
    if ($stmt->execute(['id' => $drugId])) {
        $_SESSION['success'] = "Drug deleted successfully.";
    } else {
        $_SESSION['error'] = "Failed to delete the drug. Please try again.";
    }
} else {
    $_SESSION['error'] = "Invalid drug ID.";
}

// Redirect back to the manage drugs page
header("Location: manage_drugs.php");
exit();
?>
