<?php
session_start();
include '../config/db.php';

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $method_name = htmlspecialchars(trim($_POST['method_name']));

    try {
        // Check if the payment method already exists
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM payment_methods WHERE method_name = :method_name");
        $stmt->execute(['method_name' => $method_name]);
        $exists = $stmt->fetchColumn();

        if ($exists) {
            $message = "Payment method already exists.";
        } else {
            // Insert new payment method
            $stmt = $pdo->prepare("INSERT INTO payment_methods (method_name) VALUES (:method_name)");
            $stmt->execute(['method_name' => $method_name]);
            $message = "Payment method added successfully!";
        }
    } catch (PDOException $e) {
        $message = "Error: " . $e->getMessage();
    }
}

// Fetch existing payment methods
try {
    $stmt = $pdo->query("SELECT id, method_name FROM payment_methods ORDER BY created_at DESC");
    $payment_methods = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Error fetching payment methods: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Methods - Store Management</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    
    <style>
        body {
            background-color: #f5f6fa;
            font-family: 'Mulish', sans-serif;
            overflow-x: hidden;
        }

        .content {
            margin-left: 240px;
            padding: 20px;
            transition: margin-left 0.3s ease;
        }

        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .payment-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }

        .list-group-item {
            border: none;
            border-bottom: 1px solid #eee;
            padding: 12px 15px;
        }

        .list-group-item:last-child {
            border-bottom: none;
        }

        @media (max-width: 768px) {
            .content {
                margin-left: 0;
                padding: 10px;
            }
            
            .mobile-toggle {
                display: block;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/side_bar.php'; ?>

    <!-- Mobile Toggle Button -->
    <button class="mobile-toggle d-md-none" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </button>

    <div class="content">
        <!-- Top Bar -->
        <div class="top-bar">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Payment Methods</h4>
                <a href="settings.php" class="btn btn-outline-primary">
                    <i class="fas fa-arrow-left"></i> Back to Settings
                </a>
            </div>
        </div>

        <?php if (!empty($message)): ?>
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($message) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <!-- Add Payment Method Form -->
            <div class="col-md-4">
                <div class="payment-card">
                    <h5 class="mb-4">Add New Payment Method</h5>
                    <form action="add_payment_method.php" method="POST">
                        <div class="mb-3">
                            <label for="method_name" class="form-label">Method Name</label>
                            <input type="text" id="method_name" name="method_name" 
                                   class="form-control" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-plus"></i> Add Method
                        </button>
                    </form>
                </div>
            </div>

            <!-- Payment Methods List -->
            <div class="col-md-8">
                <div class="payment-card">
                    <h5 class="mb-4">Available Payment Methods</h5>
                    <?php if (!empty($payment_methods)): ?>
                        <div class="list-group">
                            <?php foreach ($payment_methods as $method): ?>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <i class="fas fa-money-bill me-2"></i>
                                        <?= htmlspecialchars($method['method_name']) ?>
                                    </div>
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-warning" 
                                                onclick="showEditModal('<?= $method['id'] ?>', '<?= htmlspecialchars($method['method_name']) ?>')">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" 
                                                onclick="confirmDelete('<?= $method['id'] ?>')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center text-muted">
                            <i class="fas fa-info-circle mb-2"></i>
                            <p>No payment methods available.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="..\libs\jquery\jquery-3.7.1.min.js"></script>
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <script>
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
            document.querySelector('.content').classList.toggle('sidebar-active');
        }

        function showEditModal(id, name) {
            // ...existing modal code...
        }

        function confirmDelete(id) {
            if (confirm("Are you sure you want to delete this payment method?")) {
                window.location.href = `delete_payment_method.php?id=${id}`;
            }
        }
    </script>
</body>
</html>
